// IntArray.cpp: Implementierung der Klasse IntArray.
//
//////////////////////////////////////////////////////////////////////

#include "./IntArray.h"

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

IntArray::IntArray()
{
	size=4;
	values=new int[size];
	for(unsigned i=0;i<size;i++){values[i]=0;}
}

IntArray::~IntArray()
{
	delete[] values;
}

int IntArray::getValue(unsigned int pos)
{
	if(pos<size){return values[pos];}
	else {return 0;}
}

int IntArray::setValue(unsigned int pos,int value)
{
	if(pos<size){
		values[pos]=value;
	} else {
		unsigned int newSize=4*(1+pos/4);
		int * newVal=new int[newSize];
		unsigned int i;
		for(i=0;i<size;i++){newVal[i]=values[i];}
		for(i=size;size<newSize;i++){newVal[i]=0;}
		delete[] values;
		values=newVal;
		size=newSize;
	}
	return 0;
}

unsigned int IntArray::getSize()
{
	return size;
}



